#!/usr/bin/env python
# Written by Kevin Nelson @ TAMUCC for Dissertation research, used as example
# code in LaTeX reformatting process. Code downloads daily ERA5 model level
# atmospheric reanalysis data.

import cdsapi
import time
import sys
import urllib3
import calendar
import numpy as np

# Suppress insecure request warnings
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

# Set the start time
stime = time.time()

# Start the CDS API client
c = cdsapi.Client()

# Set format, grid, and area for downloaded files
output_format = 'netcdf'
output_grid = '0.25/0.25'
output_area = '90.0/-180.0/-90.0/180.0' # North/West/South/East
save_path = '/cloud/data/model/era5/split_files/ml_hires/'

# Loop over each day of month to get daily files
year = '2007'
for month in ['10','11','12']:
   ndays = calendar.monthrange(int(year),int(month))[1]
   day_range = np.arange(0,ndays)+1
   if month == '10':
      day_range = np.arange(10,ndays)+1
   for dd in day_range:
      if dd<10:
         dtg = year + '-' + month + '-0' + str(dd)
      else:
         dtg = year + '-' + month + '-' + str(dd)
      if dtg=='2020-08-20':
         continue
      era5_output_name = save_path + 'era5_hires_' + dtg + '.ncdf' 
      era5_mars_call = {
         'area':output_area,
         'class':'ea',
         'date':dtg,
         'expver':'1',
         'format':output_format,
         'grid':output_grid,
         'levelist':'1/2/3/4/5/6/7/8/9/10/11/12/13/14/15/16/17/18/19/' + \
            '20/21/22/23/24/25/26/27/28/29/30/31/32/33/34/35/36/37/38/' + \
            '39/40/41/42/43/44/45/46/47/48/49/50/51/52/53/54/55/56/57/' + \
            '58/59/60/61/62/63/64/65/66/67/68/69/70/71/72/73/74/75/76/' + \
            '77/78/79/80/81/82/83/84/85/86/87/88/89/90/91/92/93/94/95/' + \
            '96/97/98/99/100/101/102/103/104/105/106/107/108/109/110/' + \
            '111/112/113/114/115/116/117/118/119/120/121/122/123/124/' + \
            '125/126/127/128/129/130/131/132/133/134/135/136/137',
         'levtype':'ml',
         'param':'75/76/129/130/131/132/133/135/138/152/155/246/247/248',
         'stream':'oper',
         'time':'00:00:00/03:00:00/06:00:00/09:00:00/12:00:00/' + \
            '15:00:00/18:00:00/21:00:00',
         'type': 'an'}
      c.retrieve('reanalysis-era5-complete', era5_mars_call, \
         era5_output_name)

# Calculate overall timer
end_time = time.time()
print('### All ERA5 data for ' + year + ' downloaded in: ' + \
   str((end_time-stime)/3600.) + ' hours. ###') 
